<?php

include("theRightPeople.php");


/** todo: get all orgs, then if custom flag (rightPeopleAPIintegration) is set, call theRightPeople.php with cvr as parameter */

/** https://api.webcrm.com/organisations */



/* WebCRM auth */
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.webcrm.com/Auth/apiLogin",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "POST",
    CURLOPT_POSTFIELDS => "",
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "authCode: 34b18518-cfbb-4212-97ac-642dd3b8e4fb"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    echo "cURL Error #:" . $err;
} else {
    // Decode JSON string into an associative array
    $array = json_decode($response, true);

// Output the array to check the result
    $bearerToken = $array['AccessToken'];
}

/** gets all orgs */
$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.webcrm.com/Organisations?Size=1000",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_POSTFIELDS => "",
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $bearerToken"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

if ($err) {
    echo "cURL Error #:" . $err;
} else {
    // Decode JSON string into an associative array
    $orgArray = json_decode($response, true);
}


// Define the helper function
function
containsAnyType($typeString, $validTypes) {
    foreach ($validTypes as $validType) {
        if (stripos($typeString, $validType) !== false) {
            return true;
        }
    }
    return false;
}

echo "<pre>";
foreach($orgArray as $org) {
    if($org["OrganisationCustom6"] == "Yes") {

       $webCrmPersons = getPersonsByOrg($org["OrganisationId"], $bearerToken);

        $existingEmails = [];

        $theRightPeopleOrgPersons = getTheRightPeopleData($org["OrganisationVatNumber"]);

        //var_dump($theRightPeopleOrgPersons);

        foreach ($webCrmPersons as $person) {
            if (!empty($person['PersonEmail'])) {
                $email = strtolower(trim($person['PersonEmail']));
                $existingEmails[$email] = $person['PersonId'];
            }
        }



        // 2. Iterate through each API response, decode JSON, and check each person’s email
        foreach ($theRightPeopleOrgPersons as $theRightPeopleOrgPerson) {
            var_dump($theRightPeopleOrgPerson);
            $data = json_decode($theRightPeopleOrgPerson, true);
            if (empty($data['persons']) || !is_array($data['persons'])) {
                continue;
            }

            foreach ($data['persons'] as $apiPerson) {
                // prepare data
                $type = $apiPerson['type'];
                $firstName = $apiPerson['firstName'];
                $lastName = $apiPerson['lastName'];
                $title = $apiPerson['position'];
                $email = $apiPerson['email'];
                $phone = $apiPerson['phone'];
                $mobilePhone = $apiPerson['mobile'];

                // Normalize the API email
                $apiEmail = isset($apiPerson['email']) ? strtolower(trim($apiPerson['email'])) : '';

                if (empty($apiEmail)) {
                    continue;
                }

                // Define your criteria arrays
                $topLevels = ['Best', 'CXO', 'Dir'];
                $validTypes1 = ['#Teknik/Prod/Kval', '#Økonomi/Finans', '#Indkøb/Adm', '#Jura', '#Gen', '#Udv/Projekt'];
                $validTypes2 = ['#Teknik/Prod/Kval', '#Økonomi/Finans', '#Indkøb/Adm', '#Jura', '#Udv/Projekt'];

                // Get values from API person
                $level = $apiPerson['level'] ?? '';
                $position = $apiPerson['position'] ?? '';
                $type = $apiPerson['type'] ?? '';

                // Check if person meets criteria using substring matching
                $meetsFirstCondition = in_array($level, $topLevels)
                    && stripos($position, 'skoleleder') === false
                    && containsAnyType($type, $validTypes1);

                $meetsSecondCondition = containsAnyType($type, $validTypes2);

                $shouldProcess = $meetsFirstCondition || $meetsSecondCondition;

                // Skip if person doesn't meet any criteria
                if (!$shouldProcess) {
                    echo "Skipping {$apiPerson['fullName']} ({$apiEmail}) - doesn't meet criteria\n";
                    continue;
                }

                var_dump($existingEmails[$apiEmail]);
                if (isset($existingEmails[$apiEmail])) {
                    // Email exists in webCRM - update existing person
                    $personId = $existingEmails[$apiEmail];

                    echo "Match found: {$apiPerson['fullName']} ({$apiEmail}) - Updating...\n";
                    updatePerson($personId, $firstName, $lastName, $title, $email, $phone, $mobilePhone, $bearerToken);

                } else {
                    // Email not in webCRM - create new person
                    echo "New person: {$apiPerson['fullName']} ({$apiEmail}) - Creating...\n";
                    createPerson($firstName, $lastName, $title, $email, $phone, $mobilePhone, $bearerToken, $org["OrganisationId"]);
                }
            }
        }

    }
}



function getPersonsByOrg($orgId, $bearerToken) {

    /** gets update or create person */
    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.webcrm.com/Persons/ByOrganisation/$orgId",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_POSTFIELDS => "",
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer $bearerToken"
        ],
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
        echo "cURL Error #:" . $err;
    } else {
        // Decode JSON string into an associative array
        return json_decode($response, true);
    }
}

function createPerson($firstName, $lastName, $title, $email, $phone, $mobilePhone, $bearerToken, $orgId) {
    var_dump($firstName);
    var_dump($lastName);
    var_dump($title);
    var_dump($email);
    var_dump($phone);
    var_dump($mobilePhone);
    var_dump($orgId);
    /** Creates person in webCRM */

    // Build the request body with person data
    $personData = [
        'PersonId' => "0",  // Required by webCRM for new records
        'PersonFirstName' => $firstName,
        'PersonLastName' => $lastName,
        'PersonTitle' => $title,
        'PersonEmail' => $email,
        'PersonDirectPhone' => $phone,
        'PersonMobilePhone' => $mobilePhone,
        'PersonOrganisationId' => $orgId
    ];

    // Remove null/empty fields BUT KEEP PersonId even if 0
    $personData = array_filter($personData, function($value, $key) {
        // Always keep PersonId and PersonOrganisationId
        if ($key === 'PersonId' || $key === 'PersonOrganisationId') {
            return true;
        }
        return $value !== null && $value !== '';
    }, ARRAY_FILTER_USE_BOTH);

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.webcrm.com/Persons",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($personData),
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer $bearerToken",
            "Content-Type: application/json",
            "Accept: application/json"
        ],
    ]);

    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
        echo "cURL Error: " . $err . "\n";
        return false;
    } else {
        if ($httpCode >= 200 && $httpCode < 300) {
            $createdPerson = json_decode($response, true);
            echo "Person created successfully. ID: " . ($createdPerson['PersonId'] ?? 'unknown') . "\n";
            return $createdPerson;
        } else {
            echo "Error creating person. HTTP Code: $httpCode\n";
            echo "Response: $response\n";
            echo "Attempted payload: " . json_encode($personData, JSON_PRETTY_PRINT) . "\n";
            return false;
        }
    }
}


function updatePerson($personId, $firstName, $lastName, $title, $email, $phone, $mobilePhone, $bearerToken) {
    /** Updates person in webCRM */

    // Build the request body with person data including PersonId
    $personData = [
        'PersonId'         => $personId,       // Include the ID so the API knows which record
        'PersonFirstName'  => $firstName,
        'PersonLastName'   => $lastName,
        'PersonTitle'      => $title,
        'PersonEmail'      => $email,
        'PersonDirectPhone'=> $phone,
        'PersonMobilePhone'=> $mobilePhone
    ];

    // Remove null/empty fields except PersonId
    $personData = array_filter($personData, function($value, $key) {
        if ($key === 'PersonId') {
            return true;
        }
        return $value !== null && $value !== '';
    }, ARRAY_FILTER_USE_BOTH);

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL           => "https://api.webcrm.com/Persons/$personId",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING       => "",
        CURLOPT_MAXREDIRS      => 10,
        CURLOPT_TIMEOUT        => 30,
        CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST  => "PUT",
        CURLOPT_POSTFIELDS     => json_encode($personData),  // JSON payload includes PersonId
        CURLOPT_HTTPHEADER     => [
            "Authorization: Bearer $bearerToken",
            "Content-Type: application/json",
            "Accept: application/json"
        ],
    ]);

    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $err      = curl_error($curl);

    curl_close($curl);

    if ($err) {
        echo "cURL Error: " . $err . "\n";
        return false;
    }

    if ($httpCode >= 200 && $httpCode < 300) {
        $updatedPerson = json_decode($response, true);
        echo "Person updated successfully. ID: $personId\n";
        return $updatedPerson;
    }

    // Validation or other error
    echo "Error updating person. HTTP Code: $httpCode\n";
    echo "Response: $response\n";
    return false;
}