<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

try {
    // Authenticate with WebCRM API
    $bearerToken = authenticateWebCRM();

    if (!$bearerToken) {
        throw new Exception('Failed to authenticate with WebCRM');
    }

    // Get organisations
    $organisations = getOrganisations($bearerToken);

    echo json_encode($organisations);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ]);
}

/**
 * Authenticate with WebCRM API
 */
function authenticateWebCRM() {
    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.webcrm.com/Auth/apiLogin",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "",
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "authCode: 34b18518-cfbb-4212-97ac-642dd3b8e4fb"
        ],
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        error_log("cURL Error: " . $err);
        return false;
    }

    $data = json_decode($response, true);
    return $data['AccessToken'] ?? false;
}

/**
 * Get all organisations from WebCRM
 */
function getOrganisations($bearerToken) {
    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.webcrm.com/Organisations?Size=1000",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_POSTFIELDS => "",
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer $bearerToken",
        ],
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        error_log("cURL Error: " . $err);
        return [];
    }

    return json_decode($response, true) ?? [];
}
?>